CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "", "critical", "CoreTech", "Adobe SwitchBoard 2.0", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "", "critical", "NonAdobePayload", "Microsoft_VC80_CRT_x86", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "", "critical", "NonAdobePayload", "Microsoft_VC90_CRT_x86", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{AA5738A8-F7B1-42CA-A2EB-0994C1F9054A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{BFEA3899-6B52-43E8-AD18-1176E6215E49}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{DDA432B5-0999-4DF0-B048-2ED98AE381A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{685B9C7D-7EBC-4382-9027-DA6F08BC28EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A519537A-6190-4373-8F2E-D3A8E44513A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{249EC133-B7EC-4462-A17F-70F3F8E92DDE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{94267924-FDF6-4BFA-978A-46B7C23989D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9B74E157-6341-4B34-95C6-280D3A9A2FC5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F26DD41E-AA82-4C9D-BE36-4B7FDAFD723B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{13B05421-2CB2-4202-8FAE-3C3731FE8835}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{63F36EC3-2B61-468D-A3C3-7229CD3D25CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3744C4FA-3BF7-422B-B83A-16157580BF72}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{CC1F29D0-21B8-49DE-B378-87FA368D82C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{26937A94-CF61-40A7-B080-540E357C2BEA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9D0254A4-3C8A-4937-9CE7-9B97D390ABF8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{691A724D-7437-43F0-A7D3-03BBC4036677}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{466909A8-1A7B-4581-B123-04DA42AC8566}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{24AE3490-0143-4C83-A6E2-5ABDF62E0BC8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{93585F2C-92CE-41E0-91CB-AAB58D5D8BA4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0CC142E3-DBA3-485B-A2E6-1FDECA14E77B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D5BABB96-4D0F-4706-9689-783674DCD3A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7F9B684A-EBF1-40A4-818C-60A091C0EF2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4593FE82-BBB2-484F-84B5-2FE4372BDB78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{91189A3A-8E67-460D-9527-B4906CDA18FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FF312380-D189-4590-9074-76D396289AA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D6C7304B-5AE7-45A6-83B7-6F226577C7DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0865BD67-A228-4E2B-9EE6-DF41974BDB6A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{DDE76CBF-C756-4869-94A7-4C69AAE32CBC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5C2585B2-5B80-4AEB-BCA7-F22450A97D5B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E6FB5ACA-8DA4-4CD7-811F-0E2BE53F629D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{56BF140E-B0BE-4D84-B54F-D2C1C42D9C7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B342F7BC-0397-47B2-8B00-BF98F84929F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{413D3D2E-E517-4E9F-9184-E8A313172D4C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1241B853-FAB3-41A7-AE0B-9A4876BCB472}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B61E503A-B597-4A1A-B43B-0C9C4FAF36A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A50253B6-030E-48F8-A202-C58E3C0176F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E29433F8-CA27-4EA2-92AF-B6F8F575BB8A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F51FB90C-88F2-47DC-AC89-8AD12E237894}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D2F18AC3-4A9E-427D-8C72-C8DCE551515F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{DC020E63-3C39-45A5-B986-E62DA6A45844}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1E8FB158-55B1-46B0-84C4-804556FFA3A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{47C3CBF6-8007-4203-99D8-018632563636}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{35307441-C2FE-4045-9944-E042E9CCA477}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{CE999562-C60E-4AA9-96DE-4FEDFB696F40}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{01A58DC7-41E8-4AD2-9103-FF915AF0E275}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{46DA0527-8C09-4D72-8925-6460C844818C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C9F436B9-D2FD-4C94-A2F1-744BDF889481}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A5082033-0B34-471E-891C-BB05D8E103FD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{965296DE-8467-46AD-8B66-D76AD90566B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{852D95AC-0F5A-4BE0-996F-90B586B306C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E597CB70-CF03-4155-B159-954F98054F73}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0C3C79C2-B988-494E-B2B2-A44A3F527049}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1268ECF7-AD16-4600-BEBB-AD0463123343}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D17258FA-8DBA-4190-B022-8DBFC198587E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{43E3B86F-670E-4F13-82DE-014380754E80}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6E994E0D-F840-466E-B01C-E615592B93BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1655DAE3-0656-4B6B-B7DE-28CC4BA3B1A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E9A467B0-5819-4453-A1D7-27709281F82B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{32648AF1-6A45-49DA-B374-9F367E9FFB36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5C09B8F2-A579-417F-AA81-C8BEDBC8B8BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{55728F10-9960-4A84-B15D-160AC6D27182}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1EFF4579-8778-485C-B9E1-18AC6088F588}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{260D79EE-90FE-4C1A-8DA4-2944FFEB2397}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B7BD9AB9-2E65-4E4E-9B2E-D751B764F38B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{09A16908-C353-45B7-984C-5B7383B7F3D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C97D2542-52A4-4DD3-8B1B-D42B600A9A74}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{17806A16-0362-4ADC-9A9B-1B20E4512313}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F9BBE574-9680-4119-B301-987AAF7E7FE9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D41F0389-B081-4FB4-972F-A046135DB751}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9C2A5E85-E70B-4E3C-952C-58C343727624}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2ED570B8-9F0E-461B-8EC0-0F2CFC346B8D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{697BFFBC-D4AB-4912-9423-89EDC8BDBA5E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{91596833-726E-4DD8-A57F-7675C6B0430D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B018A070-ECA3-4D98-BB52-F1AC7A7B2F02}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D24A56B6-1681-4EF0-8EA5-63FA4A21B8CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{511001B8-1116-4A6D-AE95-FA09DC55C8AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A45A2B99-0EFE-4A23-BE76-6B3053DA553C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1FB03535-9D52-4A73-B93D-EAEE0254568A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{54A50883-7624-4A63-8F3F-A2A69939D7BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{91134BBC-9009-4DB1-80D7-0B1101F93B28}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5F348638-919A-4454-A4B3-588BB1D93E1D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A042EC49-3A04-409F-B712-C6B8B233DB65}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{74C1C2E2-4A07-4DA4-BD63-9620D446BFC4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6C1C9F46-9B90-4062-B14F-7E6F9F1314F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FC02C401-B392-44D3-A443-D33FC3994C55}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{706D4490-7BBB-474F-89FF-5716AAFCD0E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{07011F54-A438-4917-BBA8-31EAEFA8A377}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{25F6F9FC-B85F-496A-BC37-507BF8F22F8A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6ACB90E1-C72C-4A59-8587-F019AD8ACF5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{30DEA06D-CE41-42E9-BBD2-1BACD8C81CEA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{38974574-8EA8-4E19-8452-06D33863506E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5293423F-40AD-4D65-B588-DA8D2870F9F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{97D3D601-1E8E-408D-89A8-8B6B1B4C2979}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D751ECEB-6654-4C39-B23B-383D252D968D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{86FBD246-5246-476E-86A3-4BC5FBC72C62}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F01DD0D6-33E3-4B76-BB88-37656C295E19}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7A7D0D3E-4B24-40E0-B576-59E07D4C28BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{90893BCA-A461-492C-8576-85EAF1B13C4C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{14D3B79B-7AFD-47A2-87A9-82F5D537F60E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{82234EC0-0236-4C2C-890E-87671E5E3C30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{DE2569B0-EE5E-4BBF-9F11-CB48C57699BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C68EBC37-C807-4DF6-8D8B-E9D6CD908FD0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{8B005EF5-F075-407D-8C03-205B3573FACE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6685118A-0800-4909-B00F-A0737F1217C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{85273E96-D4D2-4354-99E1-E73DDE99FA43}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{126B22C0-C7BC-4F93-8B18-DFC4BF0610FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F1FDB364-17CA-40B3-8F2A-E015A06C4E7F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F1850622-6FB5-4227-8144-D0DECDA7EBD1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{91C23E29-155C-4B17-89D1-703652D77F15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{318124CD-B3A2-4168-88A2-1CAD853D8D12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{72E3BDF8-477F-4CDE-A7F4-FC2942BB4D1F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{632C98FC-1C78-4EDB-ADFF-E64C83E0AD00}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{277FC2A0-F566-41EA-970C-7AD2F0D91B05}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FD224AF8-84B7-42AA-A78A-B2BEAEB73CAC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{483AF46E-C5EB-413E-B8F6-B6845741697D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{08C8BC73-C2BE-4E00-95B8-EA15F65A7B62}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{389FF9AB-ADC4-48C9-9D3B-12445E9E2AB4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1C44C306-0388-48CE-A3E0-F43B0A20CC31}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5F868E71-9B9C-4A7D-8EEE-8038D4F2C8B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{12D0F6E2-4C78-4C1F-A4A2-9002039BB50B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{94858B6F-1323-4AE6-BDEA-06398098BA95}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F2315975-B5FB-4B3C-AAF0-CADFDB907873}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{65FF64F7-83F2-4170-9913-3C2E766D55D1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{519BBBC9-2D4B-4635-B635-64F912F98CCB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{10ED8077-71DC-40D4-A66E-C9F5BE5C93AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{86AFAF5C-65A9-4B74-95CC-11DCCCC3CC14}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4CD1EF78-CA29-4D05-80F5-619C32F5F2DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1F3BFCA9-FB27-4EEF-A28C-F83FF793FFA3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C286EBF2-AFF9-4DD6-9339-70B7BCA306C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F3EEEB85-7E3F-4CBA-8CAC-CDAEE5F44E0C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{48625029-22EC-4D8C-873D-ACE645BD282D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3633E28D-ED03-43F4-9F86-04AA25F0DEF9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{CF227355-7E0C-4A6E-AB1A-4FBEC301432E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{36AC57FB-84F2-4EE2-8541-5AA4C767E6D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{22C7A661-4708-4EE0-B8F5-51F77A7FFB9F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E6F3527D-114E-43E4-B131-BD90F586D5DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B694A74B-559A-4FB5-8695-38345FF4859F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{8499C3A8-F0A5-48AF-A8C7-815CA6CFF81F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6EDBA6FB-6674-4C1D-B05A-E291513ED4E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{10444FC2-563E-47F1-BED0-C128AA6F055E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1BB516F9-4464-4973-985E-D1409BD1DC14}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1C00AAF3-7676-43EC-A228-824219D8585D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FDCE1BDC-75BB-47EC-8BB2-8690B2F0E6E8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F2D05694-0047-493E-8FB5-09B2ADD50748}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5F1DF572-3C4E-48BB-9E3B-1468C99669CA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3058883C-F032-4B8F-86CB-32CC480B0118}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{30A258D4-68F3-4EDD-9E25-D7A96418EB5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1C3A8BF0-082F-4808-8EAD-3FDB80DBE133}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6A7EAFAF-94C8-4027-B9F4-84131A5A8C14}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5828F037-1E44-43A3-BAD8-599D5FD9567D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{364E29A9-4411-4828-9380-8707D57F0AA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7EA9D0F9-06C5-4E7E-B131-21885509248F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F64953D3-A9C8-4866-9B4E-79A9FF9A247A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{8340149C-B75A-4149-812B-18E5F5E02560}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{69439D87-54AE-4B58-B835-F647ABB5D62C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E757158F-C611-46EA-86BB-5D265B4D8AE9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{367CBD4F-F47E-48A3-AD47-CBCCF70E2BB6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A42B0980-784C-446A-9A0E-E9A4676A5907}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1B206740-E983-4A74-9970-AA46C27E08F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9A6BF3FE-521B-4393-BC58-C888BDC795ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{77FF09EE-DFD2-42F1-AA6C-C39CE0D93D32}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A564A44F-6B2B-49F7-BDAC-DBE2D89B95FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{382317FE-FC3E-453A-9F1A-CA4AA16B6DCC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2D00B0B9-8806-4443-9BCF-6E72DD810B95}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6EB53561-4847-4D16-BBF7-826168A2823D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E46FC4C1-EF9E-40FC-ACCE-F98AE5082957}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3CC0A3AA-24A2-428C-8D3A-598C17423168}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{8849BDCA-AC0F-47AF-AD09-10D339B64525}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C81D8FE3-CA26-4051-9744-6414B210F479}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C2D57F59-D9D9-45B6-B25F-C477884B6B51}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{BB76B67C-4254-4068-8955-BCF5BE96F46F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E8BC7D9A-C949-4433-9C6F-9A10CEE98CB8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{EA11B838-70EC-4F6E-9195-FA1992D12609}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{97697B0F-4455-4DF8-BAFB-07858909EC21}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D4999F73-24C2-4373-A8EA-C4748A6FB222}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5EBC2764-04A8-482C-A700-AA44438C8BCE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{BDA4CE2E-1C43-4CB1-96BB-1803AEAB9A95}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F7D1692B-7963-4CEA-98DD-8C6F05984297}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{239D219C-87FF-4DD4-945C-AE042DA27637}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{99570301-3142-4A45-A290-111D40C476B3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{BC13277F-30E0-40F5-A917-15230E27CF01}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{EA58BE8A-0983-49BB-A726-584BD6D470BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3914828C-4248-412C-8F81-D1ED00AE9BB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7F4FCC8E-5989-43A3-83CA-575B921A8ADE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{98D2063E-9C5A-47A7-B235-61AAD3F0CF16}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{02D2FFBD-7CCD-4C08-8083-E4E715DA5CE2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0CF9AFEA-30F7-4864-8A9D-7B5639F2EEF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4438567B-285E-4FA3-9F0B-EEA4AE58B40A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D4DFADDD-91A3-4FB4-A94D-64A95C156799}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A7DF5957-5BDB-45A0-BD44-AD713DAAE684}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{829E6950-E536-4AAE-92D5-D0372F4DC217}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E1E7C55E-E531-4E4E-A8A7-40EE3C295A5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6AA618BE-206B-4B58-95C5-C989592AE9CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5AD1184D-40CE-4F09-B9F2-653F6BE59939}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5E904285-8F6D-441E-89BF-1F008A5255F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C32E6BE6-93EA-410F-935E-687875ECB173}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{47B9D4D1-AB81-4BF7-A129-F80094C52E3B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5E405CCF-9834-4544-8A2F-2CB54637CC26}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5D454CA6-ACCC-454B-BE1B-3A73E7A4B524}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FD08FD08-BFB1-49C2-97F7-ECFA3E591ED6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9C894D66-7A45-43CB-8C50-B22822916AC8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4A2C2EFF-93B5-41D2-9D6A-E4C10E8B37CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{845CE9CD-C550-40FE-8806-D021A8334488}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E37ACC8D-7AC5-49F9-8B88-227E4211F558}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{930E2E92-E80D-4F20-8059-EA91E86C75D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A0AA2067-4F5A-4F6A-AFBE-A09959C2BE38}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{DF4FAFE5-B410-4330-B4D5-1D2AD0C0E502}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{158E638D-5CF3-4075-801F-8326A6ED684B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2F380D58-D03A-4410-97DE-7FF1B1A848DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{EE43B080-96D1-44C8-A6AA-383629930E50}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FA6C5B5F-BADA-4E14-9E0F-715846CADA24}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6A3A522D-3A67-41C6-B094-9FD7F5E34B9F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5F673A1D-E7F4-4845-9A37-6CE7A5157CBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FF0A2B5C-313D-4F71-AB67-C359412B05EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{96150119-C90D-4CF4-9D68-58137F0058D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{759AC15D-DE73-426F-A672-683EFD29342A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{CA3BAF23-FA52-4A16-AA45-D683F36FE558}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{AB398952-2B3D-4B41-BAF4-8C3CC6316F35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{AD706A54-C915-4E02-9B96-7230B123F4A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2B8D63C8-51CC-491B-8515-56DDBC0C18EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{ED86A949-B3F6-439D-8788-F4FB6301C562}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9A3A7BED-3F6A-4807-A7B7-525FF716CC52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3DED24A4-CF8B-479B-BE0F-7F3FFA98FB1D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{61592937-DB5B-46F6-A074-B24FFFDDDE66}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{EA37794C-0FEA-45FE-A490-48E719716770}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{AED720DB-2C32-4337-914E-8754B1BDE7F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5EFF77D7-D2A9-4D51-BF57-D672E561140A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3E8F80C6-C90A-4F7F-8F37-A23826ECF78A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{AC6A7120-A021-448D-A7D6-3C01B6708BEE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{37391F94-D92F-4422-A59B-27A979BEEE99}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A187A9C4-66F4-4076-AA73-85CA6B62C21E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0A59A70A-FFCD-470B-95E4-8AD3A165B718}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6B36A889-DD19-4A2E-B3C4-88D691960A64}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7EAE2891-F875-45AD-B348-86B2816154BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{939F3688-EDA5-4194-A6E9-F7B5F865E1AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D8A3A8B3-1175-47B4-8DA2-CB2FAC660661}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{021823D1-11B9-4308-ACD1-6C6A4DAA869F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{751BA947-D493-43E6-B762-31755E3FC532}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{02F35837-A748-4046-9587-4FD394AFAA8A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{023E2238-D974-42BD-A9E3-BD140650FC20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{DE818559-56E3-4BCA-B84C-CB690F03505F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{936F4C45-EA01-4A6B-B345-DBC1850BCD7A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1DFF4619-A95A-436B-880D-A3DB3B238517}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{ED64F143-2C81-4728-B083-6FE1E8C933EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{155F2CEB-2C14-4A47-8DEB-84465CE99C56}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B95753BE-EE39-48C4-8FDB-51836F0E6B02}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{34863C98-61D4-4C9E-AB39-F4B0C0EBF0F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C011FF28-6B87-40F3-9E27-C2482EFA8274}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{90AF0645-4A3B-4A1C-8E42-49D34D63C97C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{00E948A4-46DB-475F-BE3C-61162A8ACAC7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{CEF98D5F-A513-4D3A-A96A-9EB3ACA1A535}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5CAEED46-C34C-4C5C-BE82-CF8662F437C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{06254F86-151B-401E-A60F-6A90B310A9FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{CA7E6520-70C0-4D29-86DA-FD24A7964AF5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D216F734-9753-43C9-8DB1-EC42FB0E7757}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{90B6BD81-CBA8-4962-B451-2246DA446059}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D777621A-5055-48FB-87C7-25EFCED0A0FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C97273C7-E3F8-4205-9B7C-EC1A44FBEF06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A9071CAC-E42D-4EDF-9F6B-561D1A61446A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1688EB67-3EF7-410B-AED5-0667C1684CAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5C663D8D-6DCB-4B06-BFFE-CE94EA812DEF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{22492EFC-EBD4-414D-AF0A-F632BBC295AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{66D30E53-52DD-4208-B22F-93094ED00F65}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0E8DD841-F7E8-4B45-8822-0A36365E473F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4F8C6839-9ACB-44F6-859A-E0BB32DE19E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{37D0C9AA-DD09-48A5-BBF0-6AE55FD9F3ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9FCAAABB-C4AD-46A1-B0E7-382ED53CF097}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F4A55ACF-3FA6-428C-BA4B-CA528CE99DD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7D294EC5-5EC8-4407-834B-CD41AFBF83C5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{73018064-20A0-44C1-8A0B-D79FD978A568}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3954FC92-E5C9-4394-A6B0-55C1DFDA4EFA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{174BF475-29F8-4A74-A7B5-5412391BF0DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{62247F36-149E-4123-A449-0BCEEA504BF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{87804980-212B-486E-BFB4-501C279250CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B46203D5-F541-4F22-AC08-C3CF7F39C195}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A8F10EE2-20D2-44BF-B437-6E9B92EF8D57}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{BCD242B7-FD07-4C97-896F-1365E7A37A87}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{225083FC-9245-4A6A-B69A-AB7406A47641}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{549B77AF-4ACC-48A0-A4EF-12883FB85931}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{54884656-BC45-4002-8ACE-BA4747EBB927}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E43EE270-DCC1-4380-8ECE-5836046A6B7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{229750FE-E12A-4E34-A567-3A6869714045}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1FA21AFE-D75E-4C78-BA93-A0BA8B005EA5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4E99135D-88D5-42B7-933D-2E36F016A475}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7B855DC7-45AD-419D-8E07-CDCC3C8D1F49}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{92778F3D-3A5B-41D4-9749-45401109D705}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{82F2943A-5DD7-4AC6-9BE6-F95844753D8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2B261745-9341-459B-916E-D092AC2D2A53}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9424DFF6-0065-4E8C-AE9D-E38DB00C9029}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E119E91A-C7A2-4F74-954A-9F8E7A618817}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{35675DF2-CCBA-45A8-B204-9A6130F6D74A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4B034792-CEF1-422A-A29B-B3EF3E2D31D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{424BD8E1-AD9D-4684-AE06-7B7AB0D3E6DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{51FB5448-FB47-491C-9EFD-28B288B5E2AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E36347C7-635F-4AAB-8D30-91D40BF386DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{72158092-1D90-430D-99CE-2EAF47BCFBE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E931A9AB-6238-4607-9FBD-C4EB11A22605}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A4DA0994-DA50-44F4-809E-6794A450020B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E83DB39F-6596-4046-97DD-3268C76AC2C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4CC95DBA-5422-4D69-9AC3-C734396FCBC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D5925363-740D-458B-B502-9C23261A9BF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6858BF27-DC37-4529-A000-31D7D099EF6A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3DB50A53-1F3D-4BFA-AD79-1CCD70D7C623}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6677906B-14B3-4671-AD8A-4A7311D0D132}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{CFA64B8B-F1B8-4C5B-9A79-689B023B02A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0C53FEB6-7DF5-45D9-AF8C-803DA97FC290}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B450E7A7-9D7A-4C0C-BCC1-4A5A81ABA863}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A980B1DA-706B-486F-A002-516937613B73}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F78825C4-CBC1-4C4F-8B93-1C45C17C9F50}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7AA4F11D-2FD0-441D-B9B7-6104069E66BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{D865F1B3-B72F-4780-8526-F03780F1AD7D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7F5BA820-F3A6-4D08-9A95-95A6190057D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0DA82C19-2931-48C6-A958-B873701C6C03}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6B961B6D-8125-4E2F-8688-1EF7009CDB8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B57CBDE6-90D5-4B45-BCBD-669B042FB3A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2FA23F36-8F39-4057-885D-087500FE7466}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5A740515-45CC-42C1-B7BE-BA9C663B36A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5BAE773C-B81A-4B2B-82C7-3028B11A85DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E88857F9-ED3E-433E-8DF8-48560311CBB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B981E994-F256-442F-AB1A-55D439E94C67}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{27BC4EE0-3DE8-4D6E-B9A7-2E3F85F5046E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{91E03620-DE1E-47A9-8DAD-41D3B67B69CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0A0B6C30-A393-4159-BD93-96A6644C8C8B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F2975223-7E8A-44E6-84E7-031ABBA56CFC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3738004B-F2EC-44D1-A4E0-8219442294AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{189DA94C-B7D5-4C62-8FDB-6B20249D49CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{BB8AA273-605F-4278-9A68-4D6D50AE49C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{22013D10-99C3-4289-BB50-4ED70AB88024}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2D15570D-27BB-4124-8B08-FC21EE537E13}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5E1255C9-8AD8-4C3A-B7AF-1C483A9CDEBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FF906661-E2D1-43D9-86B4-2BBA49C80322}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1FDCA7A0-6CDD-4095-A8C1-EBC62A10E55A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{18AE23D0-64BB-482A-A37F-6244C2E1247A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{536598C6-4273-4A8A-8DE7-D4F6558909A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B6837D28-13EA-4CEC-B195-BA005A9AFD09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{54C9A46B-92DB-4588-B5B0-E7F431721BDD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{15C041E4-E5EC-4735-B725-686D7C2E79CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{AD0D6BCF-A5E1-4D4A-8FEF-730302381449}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{DA654F08-3116-4F4C-96F9-74B5400D94B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E65B9805-1491-4646-A348-897966FD8673}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{EA92A81A-2EE9-4F66-9A3C-5E9234D582CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9AA4F17C-68DD-4AC5-A24A-553B198A0E81}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{3E298F95-5609-4B13-98F9-1D2EBE4D3B27}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{45C6828E-BD12-46E8-AAE3-DC4EAC36AD8A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{77A0AEDD-04DD-4E0D-92CB-665F15CCE5C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F236F367-4724-4FA7-9EBF-3215A008C8AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0117C0DC-7FC7-423B-A6CF-B5EB943BCCF1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7CBFDBAC-F83F-4168-AD39-559450572A21}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{965B7CF8-7452-49B1-A757-6A79DB6B35E7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4792D45D-19C9-4267-9903-5ACA49A6C5DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A9C8BEC4-4884-4634-BCD2-36AA115EE8CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{F19C1D0A-DD08-491C-B1C0-2EDE1FA88C3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{0ED34AC0-9C6A-4923-922E-214F67F5F172}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2BCEB0DB-426B-4D68-B32F-BF4F03F4EFE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6D6F0813-EC0B-4FA7-9222-A38D5E2D16F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{15ABBE61-D439-43D1-959D-9B37B79E33CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{E6EF4BD6-F1C3-4DD8-A861-8291B387C173}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{4FF20D3F-5045-4BAB-8D05-45C1ACC1CA21}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B565F1D3-B49D-49AF-B116-A4A5617063A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C47A9DDE-8A51-4786-BAEF-106DA636E2AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1F18B7B7-4DD7-4451-9474-CACF115407A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5DCC7DC0-8B35-4699-BAE4-2695BAFA4B8E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6E7BE028-435A-47B8-98D7-9BB029CB2890}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{683A0E75-A6ED-4A15-8E9B-C00500C4FB9D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{6068BFE8-A060-4D34-9CAF-D26E4A05AFE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{FB43701D-2C3A-4994-92FA-BAE944DE7A68}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B20A7E3D-D00A-4CAD-8191-9C28F5446B79}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{1C2438F0-0790-4463-92F0-4463C69DEC91}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{78ED15DD-1127-4077-9593-27D0DECE1795}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{31ED54CD-498A-40ED-B555-2B6350359295}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{B49C2FD3-B1F2-43B9-B000-CA056EA24562}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{208D4140-9780-4504-9F1C-2F81819E49D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{9D4AE88F-02FA-4B28-B5DC-A27A0CD8659B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{70AF74F2-2228-48E3-B242-0CB99F9E7F55}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{5E1B8343-A0B3-40BD-8548-838A4C3C50E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{A3E262B5-0818-4DD2-8831-74D4A5FA5316}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{86BB0912-7FA3-4D4B-A533-5A515C05E960}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{2C5930A2-BC06-4D47-A899-DCFD8A64E4E8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{7A825C70-821B-47CB-B365-0B8A34629512}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "{C7E28754-3919-46AA-9FEC-EB49C765F4D5}", "upgrade", "", "", "")
INSERT INTO Payloads VALUES	("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "Standard", "Adobe Mini Bridge CS5", "1", "normal")
INSERT INTO PayloadData VALUES("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "0" , "PayloadInfo", '<PayloadInfo version="3.0.116.0"><BuildInfo>
    <Property name="Created">2010-03-08 15:21:01.894000</Property>
    <Property name="TargetName">AdobeMiniBridge1-mul</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{4438C826-1FD0-4D04-A70B-24FE1580AB21}</Property>
    <Property name="ProductName">Adobe Mini Bridge CS5</Property>
    <Property name="ProductVersion">1</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[AdobeCommon]\CS5ServiceManager\extensions\Adobe Mini Bridge CS5</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
		<Family>Standard</Family>
		<ProductName>Adobe Mini Bridge CS5</ProductName>
	<ProductVersion>1</ProductVersion>
    </ProductInfo>
  </Satisfies><Dependencies>
    <ProductInfo type="critical">
      <Family>CoreTech</Family>
      <ProductName>Adobe SwitchBoard 2.0</ProductName>
    </ProductInfo>
    <ProductInfo type="critical">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft_VC80_CRT_x86</ProductName>
    </ProductInfo>
    <ProductInfo type="critical">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft_VC90_CRT_x86</ProductName>
    </ProductInfo>
  </Dependencies><Upgrades>
    <AdobeCode>{AA5738A8-F7B1-42CA-A2EB-0994C1F9054A}</AdobeCode>
    <AdobeCode>{BFEA3899-6B52-43E8-AD18-1176E6215E49}</AdobeCode>
    <AdobeCode>{DDA432B5-0999-4DF0-B048-2ED98AE381A6}</AdobeCode>
    <AdobeCode>{685B9C7D-7EBC-4382-9027-DA6F08BC28EE}</AdobeCode>
    <AdobeCode>{A519537A-6190-4373-8F2E-D3A8E44513A7}</AdobeCode>
    <AdobeCode>{249EC133-B7EC-4462-A17F-70F3F8E92DDE}</AdobeCode>
    <AdobeCode>{94267924-FDF6-4BFA-978A-46B7C23989D3}</AdobeCode>
    <AdobeCode>{9B74E157-6341-4B34-95C6-280D3A9A2FC5}</AdobeCode>
    <AdobeCode>{F26DD41E-AA82-4C9D-BE36-4B7FDAFD723B}</AdobeCode>
    <AdobeCode>{13B05421-2CB2-4202-8FAE-3C3731FE8835}</AdobeCode>
    <AdobeCode>{63F36EC3-2B61-468D-A3C3-7229CD3D25CD}</AdobeCode>
    <AdobeCode>{3744C4FA-3BF7-422B-B83A-16157580BF72}</AdobeCode>
    <AdobeCode>{CC1F29D0-21B8-49DE-B378-87FA368D82C3}</AdobeCode>
    <AdobeCode>{26937A94-CF61-40A7-B080-540E357C2BEA}</AdobeCode>
    <AdobeCode>{9D0254A4-3C8A-4937-9CE7-9B97D390ABF8}</AdobeCode>
    <AdobeCode>{691A724D-7437-43F0-A7D3-03BBC4036677}</AdobeCode>
    <AdobeCode>{466909A8-1A7B-4581-B123-04DA42AC8566}</AdobeCode>
    <AdobeCode>{24AE3490-0143-4C83-A6E2-5ABDF62E0BC8}</AdobeCode>
    <AdobeCode>{93585F2C-92CE-41E0-91CB-AAB58D5D8BA4}</AdobeCode>
    <AdobeCode>{0CC142E3-DBA3-485B-A2E6-1FDECA14E77B}</AdobeCode>
    <AdobeCode>{D5BABB96-4D0F-4706-9689-783674DCD3A0}</AdobeCode>
    <AdobeCode>{7F9B684A-EBF1-40A4-818C-60A091C0EF2D}</AdobeCode>
    <AdobeCode>{4593FE82-BBB2-484F-84B5-2FE4372BDB78}</AdobeCode>
    <AdobeCode>{91189A3A-8E67-460D-9527-B4906CDA18FE}</AdobeCode>
    <AdobeCode>{FF312380-D189-4590-9074-76D396289AA2}</AdobeCode>
    <AdobeCode>{D6C7304B-5AE7-45A6-83B7-6F226577C7DA}</AdobeCode>
    <AdobeCode>{0865BD67-A228-4E2B-9EE6-DF41974BDB6A}</AdobeCode>
    <AdobeCode>{DDE76CBF-C756-4869-94A7-4C69AAE32CBC}</AdobeCode>
    <AdobeCode>{5C2585B2-5B80-4AEB-BCA7-F22450A97D5B}</AdobeCode>
    <AdobeCode>{E6FB5ACA-8DA4-4CD7-811F-0E2BE53F629D}</AdobeCode>
    <AdobeCode>{56BF140E-B0BE-4D84-B54F-D2C1C42D9C7C}</AdobeCode>
    <AdobeCode>{B342F7BC-0397-47B2-8B00-BF98F84929F3}</AdobeCode>
    <AdobeCode>{413D3D2E-E517-4E9F-9184-E8A313172D4C}</AdobeCode>
    <AdobeCode>{1241B853-FAB3-41A7-AE0B-9A4876BCB472}</AdobeCode>
    <AdobeCode>{B61E503A-B597-4A1A-B43B-0C9C4FAF36A7}</AdobeCode>
    <AdobeCode>{A50253B6-030E-48F8-A202-C58E3C0176F0}</AdobeCode>
    <AdobeCode>{E29433F8-CA27-4EA2-92AF-B6F8F575BB8A}</AdobeCode>
    <AdobeCode>{F51FB90C-88F2-47DC-AC89-8AD12E237894}</AdobeCode>
    <AdobeCode>{D2F18AC3-4A9E-427D-8C72-C8DCE551515F}</AdobeCode>
    <AdobeCode>{DC020E63-3C39-45A5-B986-E62DA6A45844}</AdobeCode>
    <AdobeCode>{1E8FB158-55B1-46B0-84C4-804556FFA3A5}</AdobeCode>
    <AdobeCode>{47C3CBF6-8007-4203-99D8-018632563636}</AdobeCode>
    <AdobeCode>{35307441-C2FE-4045-9944-E042E9CCA477}</AdobeCode>
    <AdobeCode>{CE999562-C60E-4AA9-96DE-4FEDFB696F40}</AdobeCode>
    <AdobeCode>{01A58DC7-41E8-4AD2-9103-FF915AF0E275}</AdobeCode>
    <AdobeCode>{46DA0527-8C09-4D72-8925-6460C844818C}</AdobeCode>
    <AdobeCode>{C9F436B9-D2FD-4C94-A2F1-744BDF889481}</AdobeCode>
    <AdobeCode>{A5082033-0B34-471E-891C-BB05D8E103FD}</AdobeCode>
    <AdobeCode>{965296DE-8467-46AD-8B66-D76AD90566B8}</AdobeCode>
    <AdobeCode>{852D95AC-0F5A-4BE0-996F-90B586B306C7}</AdobeCode>
    <AdobeCode>{E597CB70-CF03-4155-B159-954F98054F73}</AdobeCode>
    <AdobeCode>{0C3C79C2-B988-494E-B2B2-A44A3F527049}</AdobeCode>
    <AdobeCode>{1268ECF7-AD16-4600-BEBB-AD0463123343}</AdobeCode>
    <AdobeCode>{D17258FA-8DBA-4190-B022-8DBFC198587E}</AdobeCode>
    <AdobeCode>{43E3B86F-670E-4F13-82DE-014380754E80}</AdobeCode>
    <AdobeCode>{6E994E0D-F840-466E-B01C-E615592B93BA}</AdobeCode>
    <AdobeCode>{1655DAE3-0656-4B6B-B7DE-28CC4BA3B1A3}</AdobeCode>
    <AdobeCode>{E9A467B0-5819-4453-A1D7-27709281F82B}</AdobeCode>
    <AdobeCode>{32648AF1-6A45-49DA-B374-9F367E9FFB36}</AdobeCode>
    <AdobeCode>{5C09B8F2-A579-417F-AA81-C8BEDBC8B8BE}</AdobeCode>
    <AdobeCode>{55728F10-9960-4A84-B15D-160AC6D27182}</AdobeCode>
    <AdobeCode>{1EFF4579-8778-485C-B9E1-18AC6088F588}</AdobeCode>
    <AdobeCode>{260D79EE-90FE-4C1A-8DA4-2944FFEB2397}</AdobeCode>
    <AdobeCode>{B7BD9AB9-2E65-4E4E-9B2E-D751B764F38B}</AdobeCode>
    <AdobeCode>{09A16908-C353-45B7-984C-5B7383B7F3D0}</AdobeCode>
    <AdobeCode>{C97D2542-52A4-4DD3-8B1B-D42B600A9A74}</AdobeCode>
    <AdobeCode>{17806A16-0362-4ADC-9A9B-1B20E4512313}</AdobeCode>
    <AdobeCode>{F9BBE574-9680-4119-B301-987AAF7E7FE9}</AdobeCode>
    <AdobeCode>{D41F0389-B081-4FB4-972F-A046135DB751}</AdobeCode>
    <AdobeCode>{9C2A5E85-E70B-4E3C-952C-58C343727624}</AdobeCode>
    <AdobeCode>{2ED570B8-9F0E-461B-8EC0-0F2CFC346B8D}</AdobeCode>
    <AdobeCode>{697BFFBC-D4AB-4912-9423-89EDC8BDBA5E}</AdobeCode>
    <AdobeCode>{91596833-726E-4DD8-A57F-7675C6B0430D}</AdobeCode>
    <AdobeCode>{B018A070-ECA3-4D98-BB52-F1AC7A7B2F02}</AdobeCode>
    <AdobeCode>{D24A56B6-1681-4EF0-8EA5-63FA4A21B8CD}</AdobeCode>
    <AdobeCode>{511001B8-1116-4A6D-AE95-FA09DC55C8AA}</AdobeCode>
    <AdobeCode>{A45A2B99-0EFE-4A23-BE76-6B3053DA553C}</AdobeCode>
    <AdobeCode>{1FB03535-9D52-4A73-B93D-EAEE0254568A}</AdobeCode>
    <AdobeCode>{54A50883-7624-4A63-8F3F-A2A69939D7BA}</AdobeCode>
    <AdobeCode>{91134BBC-9009-4DB1-80D7-0B1101F93B28}</AdobeCode>
    <AdobeCode>{5F348638-919A-4454-A4B3-588BB1D93E1D}</AdobeCode>
    <AdobeCode>{A042EC49-3A04-409F-B712-C6B8B233DB65}</AdobeCode>
    <AdobeCode>{74C1C2E2-4A07-4DA4-BD63-9620D446BFC4}</AdobeCode>
    <AdobeCode>{6C1C9F46-9B90-4062-B14F-7E6F9F1314F2}</AdobeCode>
    <AdobeCode>{FC02C401-B392-44D3-A443-D33FC3994C55}</AdobeCode>
    <AdobeCode>{706D4490-7BBB-474F-89FF-5716AAFCD0E1}</AdobeCode>
    <AdobeCode>{07011F54-A438-4917-BBA8-31EAEFA8A377}</AdobeCode>
    <AdobeCode>{25F6F9FC-B85F-496A-BC37-507BF8F22F8A}</AdobeCode>
    <AdobeCode>{6ACB90E1-C72C-4A59-8587-F019AD8ACF5A}</AdobeCode>
    <AdobeCode>{30DEA06D-CE41-42E9-BBD2-1BACD8C81CEA}</AdobeCode>
    <AdobeCode>{38974574-8EA8-4E19-8452-06D33863506E}</AdobeCode>
    <AdobeCode>{5293423F-40AD-4D65-B588-DA8D2870F9F1}</AdobeCode>
    <AdobeCode>{97D3D601-1E8E-408D-89A8-8B6B1B4C2979}</AdobeCode>
    <AdobeCode>{D751ECEB-6654-4C39-B23B-383D252D968D}</AdobeCode>
    <AdobeCode>{86FBD246-5246-476E-86A3-4BC5FBC72C62}</AdobeCode>
    <AdobeCode>{F01DD0D6-33E3-4B76-BB88-37656C295E19}</AdobeCode>
    <AdobeCode>{7A7D0D3E-4B24-40E0-B576-59E07D4C28BE}</AdobeCode>
    <AdobeCode>{90893BCA-A461-492C-8576-85EAF1B13C4C}</AdobeCode>
    <AdobeCode>{14D3B79B-7AFD-47A2-87A9-82F5D537F60E}</AdobeCode>
    <AdobeCode>{82234EC0-0236-4C2C-890E-87671E5E3C30}</AdobeCode>
    <AdobeCode>{DE2569B0-EE5E-4BBF-9F11-CB48C57699BB}</AdobeCode>
    <AdobeCode>{C68EBC37-C807-4DF6-8D8B-E9D6CD908FD0}</AdobeCode>
    <AdobeCode>{8B005EF5-F075-407D-8C03-205B3573FACE}</AdobeCode>
    <AdobeCode>{6685118A-0800-4909-B00F-A0737F1217C7}</AdobeCode>
    <AdobeCode>{85273E96-D4D2-4354-99E1-E73DDE99FA43}</AdobeCode>
    <AdobeCode>{126B22C0-C7BC-4F93-8B18-DFC4BF0610FE}</AdobeCode>
    <AdobeCode>{F1FDB364-17CA-40B3-8F2A-E015A06C4E7F}</AdobeCode>
    <AdobeCode>{F1850622-6FB5-4227-8144-D0DECDA7EBD1}</AdobeCode>
    <AdobeCode>{91C23E29-155C-4B17-89D1-703652D77F15}</AdobeCode>
    <AdobeCode>{318124CD-B3A2-4168-88A2-1CAD853D8D12}</AdobeCode>
    <AdobeCode>{72E3BDF8-477F-4CDE-A7F4-FC2942BB4D1F}</AdobeCode>
    <AdobeCode>{632C98FC-1C78-4EDB-ADFF-E64C83E0AD00}</AdobeCode>
    <AdobeCode>{277FC2A0-F566-41EA-970C-7AD2F0D91B05}</AdobeCode>
    <AdobeCode>{FD224AF8-84B7-42AA-A78A-B2BEAEB73CAC}</AdobeCode>
    <AdobeCode>{483AF46E-C5EB-413E-B8F6-B6845741697D}</AdobeCode>
    <AdobeCode>{08C8BC73-C2BE-4E00-95B8-EA15F65A7B62}</AdobeCode>
    <AdobeCode>{389FF9AB-ADC4-48C9-9D3B-12445E9E2AB4}</AdobeCode>
    <AdobeCode>{1C44C306-0388-48CE-A3E0-F43B0A20CC31}</AdobeCode>
    <AdobeCode>{5F868E71-9B9C-4A7D-8EEE-8038D4F2C8B6}</AdobeCode>
    <AdobeCode>{12D0F6E2-4C78-4C1F-A4A2-9002039BB50B}</AdobeCode>
    <AdobeCode>{94858B6F-1323-4AE6-BDEA-06398098BA95}</AdobeCode>
    <AdobeCode>{F2315975-B5FB-4B3C-AAF0-CADFDB907873}</AdobeCode>
    <AdobeCode>{65FF64F7-83F2-4170-9913-3C2E766D55D1}</AdobeCode>
    <AdobeCode>{519BBBC9-2D4B-4635-B635-64F912F98CCB}</AdobeCode>
    <AdobeCode>{10ED8077-71DC-40D4-A66E-C9F5BE5C93AF}</AdobeCode>
    <AdobeCode>{86AFAF5C-65A9-4B74-95CC-11DCCCC3CC14}</AdobeCode>
    <AdobeCode>{4CD1EF78-CA29-4D05-80F5-619C32F5F2DF}</AdobeCode>
    <AdobeCode>{1F3BFCA9-FB27-4EEF-A28C-F83FF793FFA3}</AdobeCode>
    <AdobeCode>{C286EBF2-AFF9-4DD6-9339-70B7BCA306C3}</AdobeCode>
    <AdobeCode>{F3EEEB85-7E3F-4CBA-8CAC-CDAEE5F44E0C}</AdobeCode>
    <AdobeCode>{48625029-22EC-4D8C-873D-ACE645BD282D}</AdobeCode>
    <AdobeCode>{3633E28D-ED03-43F4-9F86-04AA25F0DEF9}</AdobeCode>
    <AdobeCode>{CF227355-7E0C-4A6E-AB1A-4FBEC301432E}</AdobeCode>
    <AdobeCode>{36AC57FB-84F2-4EE2-8541-5AA4C767E6D9}</AdobeCode>
    <AdobeCode>{22C7A661-4708-4EE0-B8F5-51F77A7FFB9F}</AdobeCode>
    <AdobeCode>{E6F3527D-114E-43E4-B131-BD90F586D5DC}</AdobeCode>
    <AdobeCode>{B694A74B-559A-4FB5-8695-38345FF4859F}</AdobeCode>
    <AdobeCode>{8499C3A8-F0A5-48AF-A8C7-815CA6CFF81F}</AdobeCode>
    <AdobeCode>{6EDBA6FB-6674-4C1D-B05A-E291513ED4E0}</AdobeCode>
    <AdobeCode>{10444FC2-563E-47F1-BED0-C128AA6F055E}</AdobeCode>
    <AdobeCode>{1BB516F9-4464-4973-985E-D1409BD1DC14}</AdobeCode>
    <AdobeCode>{1C00AAF3-7676-43EC-A228-824219D8585D}</AdobeCode>
    <AdobeCode>{FDCE1BDC-75BB-47EC-8BB2-8690B2F0E6E8}</AdobeCode>
    <AdobeCode>{F2D05694-0047-493E-8FB5-09B2ADD50748}</AdobeCode>
    <AdobeCode>{5F1DF572-3C4E-48BB-9E3B-1468C99669CA}</AdobeCode>
    <AdobeCode>{3058883C-F032-4B8F-86CB-32CC480B0118}</AdobeCode>
    <AdobeCode>{30A258D4-68F3-4EDD-9E25-D7A96418EB5C}</AdobeCode>
    <AdobeCode>{1C3A8BF0-082F-4808-8EAD-3FDB80DBE133}</AdobeCode>
    <AdobeCode>{6A7EAFAF-94C8-4027-B9F4-84131A5A8C14}</AdobeCode>
    <AdobeCode>{5828F037-1E44-43A3-BAD8-599D5FD9567D}</AdobeCode>
    <AdobeCode>{364E29A9-4411-4828-9380-8707D57F0AA9}</AdobeCode>
    <AdobeCode>{7EA9D0F9-06C5-4E7E-B131-21885509248F}</AdobeCode>
    <AdobeCode>{F64953D3-A9C8-4866-9B4E-79A9FF9A247A}</AdobeCode>
    <AdobeCode>{8340149C-B75A-4149-812B-18E5F5E02560}</AdobeCode>
    <AdobeCode>{69439D87-54AE-4B58-B835-F647ABB5D62C}</AdobeCode>
    <AdobeCode>{E757158F-C611-46EA-86BB-5D265B4D8AE9}</AdobeCode>
    <AdobeCode>{367CBD4F-F47E-48A3-AD47-CBCCF70E2BB6}</AdobeCode>
    <AdobeCode>{A42B0980-784C-446A-9A0E-E9A4676A5907}</AdobeCode>
    <AdobeCode>{1B206740-E983-4A74-9970-AA46C27E08F1}</AdobeCode>
    <AdobeCode>{9A6BF3FE-521B-4393-BC58-C888BDC795ED}</AdobeCode>
    <AdobeCode>{77FF09EE-DFD2-42F1-AA6C-C39CE0D93D32}</AdobeCode>
    <AdobeCode>{A564A44F-6B2B-49F7-BDAC-DBE2D89B95FB}</AdobeCode>
    <AdobeCode>{382317FE-FC3E-453A-9F1A-CA4AA16B6DCC}</AdobeCode>
    <AdobeCode>{2D00B0B9-8806-4443-9BCF-6E72DD810B95}</AdobeCode>
    <AdobeCode>{6EB53561-4847-4D16-BBF7-826168A2823D}</AdobeCode>
    <AdobeCode>{E46FC4C1-EF9E-40FC-ACCE-F98AE5082957}</AdobeCode>
    <AdobeCode>{3CC0A3AA-24A2-428C-8D3A-598C17423168}</AdobeCode>
    <AdobeCode>{8849BDCA-AC0F-47AF-AD09-10D339B64525}</AdobeCode>
    <AdobeCode>{C81D8FE3-CA26-4051-9744-6414B210F479}</AdobeCode>
    <AdobeCode>{C2D57F59-D9D9-45B6-B25F-C477884B6B51}</AdobeCode>
    <AdobeCode>{BB76B67C-4254-4068-8955-BCF5BE96F46F}</AdobeCode>
    <AdobeCode>{E8BC7D9A-C949-4433-9C6F-9A10CEE98CB8}</AdobeCode>
    <AdobeCode>{EA11B838-70EC-4F6E-9195-FA1992D12609}</AdobeCode>
    <AdobeCode>{97697B0F-4455-4DF8-BAFB-07858909EC21}</AdobeCode>
    <AdobeCode>{D4999F73-24C2-4373-A8EA-C4748A6FB222}</AdobeCode>
    <AdobeCode>{5EBC2764-04A8-482C-A700-AA44438C8BCE}</AdobeCode>
    <AdobeCode>{BDA4CE2E-1C43-4CB1-96BB-1803AEAB9A95}</AdobeCode>
    <AdobeCode>{F7D1692B-7963-4CEA-98DD-8C6F05984297}</AdobeCode>
    <AdobeCode>{239D219C-87FF-4DD4-945C-AE042DA27637}</AdobeCode>
    <AdobeCode>{99570301-3142-4A45-A290-111D40C476B3}</AdobeCode>
    <AdobeCode>{BC13277F-30E0-40F5-A917-15230E27CF01}</AdobeCode>
    <AdobeCode>{EA58BE8A-0983-49BB-A726-584BD6D470BE}</AdobeCode>
    <AdobeCode>{3914828C-4248-412C-8F81-D1ED00AE9BB5}</AdobeCode>
    <AdobeCode>{7F4FCC8E-5989-43A3-83CA-575B921A8ADE}</AdobeCode>
    <AdobeCode>{98D2063E-9C5A-47A7-B235-61AAD3F0CF16}</AdobeCode>
    <AdobeCode>{02D2FFBD-7CCD-4C08-8083-E4E715DA5CE2}</AdobeCode>
    <AdobeCode>{0CF9AFEA-30F7-4864-8A9D-7B5639F2EEF3}</AdobeCode>
    <AdobeCode>{4438567B-285E-4FA3-9F0B-EEA4AE58B40A}</AdobeCode>
    <AdobeCode>{D4DFADDD-91A3-4FB4-A94D-64A95C156799}</AdobeCode>
    <AdobeCode>{A7DF5957-5BDB-45A0-BD44-AD713DAAE684}</AdobeCode>
    <AdobeCode>{829E6950-E536-4AAE-92D5-D0372F4DC217}</AdobeCode>
    <AdobeCode>{E1E7C55E-E531-4E4E-A8A7-40EE3C295A5F}</AdobeCode>
    <AdobeCode>{6AA618BE-206B-4B58-95C5-C989592AE9CD}</AdobeCode>
    <AdobeCode>{5AD1184D-40CE-4F09-B9F2-653F6BE59939}</AdobeCode>
    <AdobeCode>{5E904285-8F6D-441E-89BF-1F008A5255F5}</AdobeCode>
    <AdobeCode>{C32E6BE6-93EA-410F-935E-687875ECB173}</AdobeCode>
    <AdobeCode>{47B9D4D1-AB81-4BF7-A129-F80094C52E3B}</AdobeCode>
    <AdobeCode>{5E405CCF-9834-4544-8A2F-2CB54637CC26}</AdobeCode>
    <AdobeCode>{5D454CA6-ACCC-454B-BE1B-3A73E7A4B524}</AdobeCode>
    <AdobeCode>{FD08FD08-BFB1-49C2-97F7-ECFA3E591ED6}</AdobeCode>
    <AdobeCode>{9C894D66-7A45-43CB-8C50-B22822916AC8}</AdobeCode>
    <AdobeCode>{4A2C2EFF-93B5-41D2-9D6A-E4C10E8B37CB}</AdobeCode>
    <AdobeCode>{845CE9CD-C550-40FE-8806-D021A8334488}</AdobeCode>
    <AdobeCode>{E37ACC8D-7AC5-49F9-8B88-227E4211F558}</AdobeCode>
    <AdobeCode>{930E2E92-E80D-4F20-8059-EA91E86C75D3}</AdobeCode>
    <AdobeCode>{A0AA2067-4F5A-4F6A-AFBE-A09959C2BE38}</AdobeCode>
    <AdobeCode>{DF4FAFE5-B410-4330-B4D5-1D2AD0C0E502}</AdobeCode>
    <AdobeCode>{158E638D-5CF3-4075-801F-8326A6ED684B}</AdobeCode>
    <AdobeCode>{2F380D58-D03A-4410-97DE-7FF1B1A848DE}</AdobeCode>
    <AdobeCode>{EE43B080-96D1-44C8-A6AA-383629930E50}</AdobeCode>
    <AdobeCode>{FA6C5B5F-BADA-4E14-9E0F-715846CADA24}</AdobeCode>
    <AdobeCode>{6A3A522D-3A67-41C6-B094-9FD7F5E34B9F}</AdobeCode>
    <AdobeCode>{5F673A1D-E7F4-4845-9A37-6CE7A5157CBE}</AdobeCode>
    <AdobeCode>{FF0A2B5C-313D-4F71-AB67-C359412B05EF}</AdobeCode>
    <AdobeCode>{96150119-C90D-4CF4-9D68-58137F0058D0}</AdobeCode>
    <AdobeCode>{759AC15D-DE73-426F-A672-683EFD29342A}</AdobeCode>
    <AdobeCode>{CA3BAF23-FA52-4A16-AA45-D683F36FE558}</AdobeCode>
    <AdobeCode>{AB398952-2B3D-4B41-BAF4-8C3CC6316F35}</AdobeCode>
    <AdobeCode>{AD706A54-C915-4E02-9B96-7230B123F4A8}</AdobeCode>
    <AdobeCode>{2B8D63C8-51CC-491B-8515-56DDBC0C18EF}</AdobeCode>
    <AdobeCode>{ED86A949-B3F6-439D-8788-F4FB6301C562}</AdobeCode>
    <AdobeCode>{9A3A7BED-3F6A-4807-A7B7-525FF716CC52}</AdobeCode>
    <AdobeCode>{3DED24A4-CF8B-479B-BE0F-7F3FFA98FB1D}</AdobeCode>
    <AdobeCode>{61592937-DB5B-46F6-A074-B24FFFDDDE66}</AdobeCode>
    <AdobeCode>{EA37794C-0FEA-45FE-A490-48E719716770}</AdobeCode>
    <AdobeCode>{AED720DB-2C32-4337-914E-8754B1BDE7F5}</AdobeCode>
    <AdobeCode>{5EFF77D7-D2A9-4D51-BF57-D672E561140A}</AdobeCode>
    <AdobeCode>{3E8F80C6-C90A-4F7F-8F37-A23826ECF78A}</AdobeCode>
    <AdobeCode>{AC6A7120-A021-448D-A7D6-3C01B6708BEE}</AdobeCode>
    <AdobeCode>{37391F94-D92F-4422-A59B-27A979BEEE99}</AdobeCode>
    <AdobeCode>{A187A9C4-66F4-4076-AA73-85CA6B62C21E}</AdobeCode>
    <AdobeCode>{0A59A70A-FFCD-470B-95E4-8AD3A165B718}</AdobeCode>
    <AdobeCode>{6B36A889-DD19-4A2E-B3C4-88D691960A64}</AdobeCode>
    <AdobeCode>{7EAE2891-F875-45AD-B348-86B2816154BC}</AdobeCode>
    <AdobeCode>{939F3688-EDA5-4194-A6E9-F7B5F865E1AE}</AdobeCode>
    <AdobeCode>{D8A3A8B3-1175-47B4-8DA2-CB2FAC660661}</AdobeCode>
    <AdobeCode>{021823D1-11B9-4308-ACD1-6C6A4DAA869F}</AdobeCode>
    <AdobeCode>{751BA947-D493-43E6-B762-31755E3FC532}</AdobeCode>
    <AdobeCode>{02F35837-A748-4046-9587-4FD394AFAA8A}</AdobeCode>
    <AdobeCode>{023E2238-D974-42BD-A9E3-BD140650FC20}</AdobeCode>
    <AdobeCode>{DE818559-56E3-4BCA-B84C-CB690F03505F}</AdobeCode>
    <AdobeCode>{936F4C45-EA01-4A6B-B345-DBC1850BCD7A}</AdobeCode>
    <AdobeCode>{1DFF4619-A95A-436B-880D-A3DB3B238517}</AdobeCode>
    <AdobeCode>{ED64F143-2C81-4728-B083-6FE1E8C933EA}</AdobeCode>
    <AdobeCode>{155F2CEB-2C14-4A47-8DEB-84465CE99C56}</AdobeCode>
    <AdobeCode>{B95753BE-EE39-48C4-8FDB-51836F0E6B02}</AdobeCode>
    <AdobeCode>{34863C98-61D4-4C9E-AB39-F4B0C0EBF0F1}</AdobeCode>
    <AdobeCode>{C011FF28-6B87-40F3-9E27-C2482EFA8274}</AdobeCode>
    <AdobeCode>{90AF0645-4A3B-4A1C-8E42-49D34D63C97C}</AdobeCode>
    <AdobeCode>{00E948A4-46DB-475F-BE3C-61162A8ACAC7}</AdobeCode>
    <AdobeCode>{CEF98D5F-A513-4D3A-A96A-9EB3ACA1A535}</AdobeCode>
    <AdobeCode>{5CAEED46-C34C-4C5C-BE82-CF8662F437C0}</AdobeCode>
    <AdobeCode>{06254F86-151B-401E-A60F-6A90B310A9FB}</AdobeCode>
    <AdobeCode>{CA7E6520-70C0-4D29-86DA-FD24A7964AF5}</AdobeCode>
    <AdobeCode>{D216F734-9753-43C9-8DB1-EC42FB0E7757}</AdobeCode>
    <AdobeCode>{90B6BD81-CBA8-4962-B451-2246DA446059}</AdobeCode>
    <AdobeCode>{D777621A-5055-48FB-87C7-25EFCED0A0FE}</AdobeCode>
    <AdobeCode>{C97273C7-E3F8-4205-9B7C-EC1A44FBEF06}</AdobeCode>
    <AdobeCode>{A9071CAC-E42D-4EDF-9F6B-561D1A61446A}</AdobeCode>
    <AdobeCode>{1688EB67-3EF7-410B-AED5-0667C1684CAD}</AdobeCode>
    <AdobeCode>{5C663D8D-6DCB-4B06-BFFE-CE94EA812DEF}</AdobeCode>
    <AdobeCode>{22492EFC-EBD4-414D-AF0A-F632BBC295AD}</AdobeCode>
    <AdobeCode>{66D30E53-52DD-4208-B22F-93094ED00F65}</AdobeCode>
    <AdobeCode>{0E8DD841-F7E8-4B45-8822-0A36365E473F}</AdobeCode>
    <AdobeCode>{4F8C6839-9ACB-44F6-859A-E0BB32DE19E6}</AdobeCode>
    <AdobeCode>{37D0C9AA-DD09-48A5-BBF0-6AE55FD9F3ED}</AdobeCode>
    <AdobeCode>{9FCAAABB-C4AD-46A1-B0E7-382ED53CF097}</AdobeCode>
    <AdobeCode>{F4A55ACF-3FA6-428C-BA4B-CA528CE99DD4}</AdobeCode>
    <AdobeCode>{7D294EC5-5EC8-4407-834B-CD41AFBF83C5}</AdobeCode>
    <AdobeCode>{73018064-20A0-44C1-8A0B-D79FD978A568}</AdobeCode>
    <AdobeCode>{3954FC92-E5C9-4394-A6B0-55C1DFDA4EFA}</AdobeCode>
    <AdobeCode>{174BF475-29F8-4A74-A7B5-5412391BF0DD}</AdobeCode>
    <AdobeCode>{62247F36-149E-4123-A449-0BCEEA504BF3}</AdobeCode>
    <AdobeCode>{87804980-212B-486E-BFB4-501C279250CD}</AdobeCode>
    <AdobeCode>{B46203D5-F541-4F22-AC08-C3CF7F39C195}</AdobeCode>
    <AdobeCode>{A8F10EE2-20D2-44BF-B437-6E9B92EF8D57}</AdobeCode>
    <AdobeCode>{BCD242B7-FD07-4C97-896F-1365E7A37A87}</AdobeCode>
    <AdobeCode>{225083FC-9245-4A6A-B69A-AB7406A47641}</AdobeCode>
    <AdobeCode>{549B77AF-4ACC-48A0-A4EF-12883FB85931}</AdobeCode>
    <AdobeCode>{54884656-BC45-4002-8ACE-BA4747EBB927}</AdobeCode>
    <AdobeCode>{E43EE270-DCC1-4380-8ECE-5836046A6B7C}</AdobeCode>
    <AdobeCode>{229750FE-E12A-4E34-A567-3A6869714045}</AdobeCode>
    <AdobeCode>{1FA21AFE-D75E-4C78-BA93-A0BA8B005EA5}</AdobeCode>
    <AdobeCode>{4E99135D-88D5-42B7-933D-2E36F016A475}</AdobeCode>
    <AdobeCode>{7B855DC7-45AD-419D-8E07-CDCC3C8D1F49}</AdobeCode>
    <AdobeCode>{92778F3D-3A5B-41D4-9749-45401109D705}</AdobeCode>
    <AdobeCode>{82F2943A-5DD7-4AC6-9BE6-F95844753D8F}</AdobeCode>
    <AdobeCode>{2B261745-9341-459B-916E-D092AC2D2A53}</AdobeCode>
    <AdobeCode>{9424DFF6-0065-4E8C-AE9D-E38DB00C9029}</AdobeCode>
    <AdobeCode>{E119E91A-C7A2-4F74-954A-9F8E7A618817}</AdobeCode>
    <AdobeCode>{35675DF2-CCBA-45A8-B204-9A6130F6D74A}</AdobeCode>
    <AdobeCode>{4B034792-CEF1-422A-A29B-B3EF3E2D31D3}</AdobeCode>
    <AdobeCode>{424BD8E1-AD9D-4684-AE06-7B7AB0D3E6DA}</AdobeCode>
    <AdobeCode>{51FB5448-FB47-491C-9EFD-28B288B5E2AC}</AdobeCode>
    <AdobeCode>{E36347C7-635F-4AAB-8D30-91D40BF386DB}</AdobeCode>
    <AdobeCode>{72158092-1D90-430D-99CE-2EAF47BCFBE4}</AdobeCode>
    <AdobeCode>{E931A9AB-6238-4607-9FBD-C4EB11A22605}</AdobeCode>
    <AdobeCode>{A4DA0994-DA50-44F4-809E-6794A450020B}</AdobeCode>
    <AdobeCode>{E83DB39F-6596-4046-97DD-3268C76AC2C1}</AdobeCode>
    <AdobeCode>{4CC95DBA-5422-4D69-9AC3-C734396FCBC1}</AdobeCode>
    <AdobeCode>{D5925363-740D-458B-B502-9C23261A9BF7}</AdobeCode>
    <AdobeCode>{6858BF27-DC37-4529-A000-31D7D099EF6A}</AdobeCode>
    <AdobeCode>{3DB50A53-1F3D-4BFA-AD79-1CCD70D7C623}</AdobeCode>
    <AdobeCode>{6677906B-14B3-4671-AD8A-4A7311D0D132}</AdobeCode>
    <AdobeCode>{CFA64B8B-F1B8-4C5B-9A79-689B023B02A2}</AdobeCode>
    <AdobeCode>{0C53FEB6-7DF5-45D9-AF8C-803DA97FC290}</AdobeCode>
    <AdobeCode>{B450E7A7-9D7A-4C0C-BCC1-4A5A81ABA863}</AdobeCode>
    <AdobeCode>{A980B1DA-706B-486F-A002-516937613B73}</AdobeCode>
    <AdobeCode>{F78825C4-CBC1-4C4F-8B93-1C45C17C9F50}</AdobeCode>
    <AdobeCode>{7AA4F11D-2FD0-441D-B9B7-6104069E66BC}</AdobeCode>
    <AdobeCode>{D865F1B3-B72F-4780-8526-F03780F1AD7D}</AdobeCode>
    <AdobeCode>{7F5BA820-F3A6-4D08-9A95-95A6190057D7}</AdobeCode>
    <AdobeCode>{0DA82C19-2931-48C6-A958-B873701C6C03}</AdobeCode>
    <AdobeCode>{6B961B6D-8125-4E2F-8688-1EF7009CDB8F}</AdobeCode>
    <AdobeCode>{B57CBDE6-90D5-4B45-BCBD-669B042FB3A1}</AdobeCode>
    <AdobeCode>{2FA23F36-8F39-4057-885D-087500FE7466}</AdobeCode>
    <AdobeCode>{5A740515-45CC-42C1-B7BE-BA9C663B36A4}</AdobeCode>
    <AdobeCode>{5BAE773C-B81A-4B2B-82C7-3028B11A85DF}</AdobeCode>
    <AdobeCode>{E88857F9-ED3E-433E-8DF8-48560311CBB1}</AdobeCode>
    <AdobeCode>{B981E994-F256-442F-AB1A-55D439E94C67}</AdobeCode>
    <AdobeCode>{27BC4EE0-3DE8-4D6E-B9A7-2E3F85F5046E}</AdobeCode>
    <AdobeCode>{91E03620-DE1E-47A9-8DAD-41D3B67B69CF}</AdobeCode>
    <AdobeCode>{0A0B6C30-A393-4159-BD93-96A6644C8C8B}</AdobeCode>
    <AdobeCode>{F2975223-7E8A-44E6-84E7-031ABBA56CFC}</AdobeCode>
    <AdobeCode>{3738004B-F2EC-44D1-A4E0-8219442294AC}</AdobeCode>
    <AdobeCode>{189DA94C-B7D5-4C62-8FDB-6B20249D49CD}</AdobeCode>
    <AdobeCode>{BB8AA273-605F-4278-9A68-4D6D50AE49C8}</AdobeCode>
    <AdobeCode>{22013D10-99C3-4289-BB50-4ED70AB88024}</AdobeCode>
    <AdobeCode>{2D15570D-27BB-4124-8B08-FC21EE537E13}</AdobeCode>
    <AdobeCode>{5E1255C9-8AD8-4C3A-B7AF-1C483A9CDEBE}</AdobeCode>
    <AdobeCode>{FF906661-E2D1-43D9-86B4-2BBA49C80322}</AdobeCode>
    <AdobeCode>{1FDCA7A0-6CDD-4095-A8C1-EBC62A10E55A}</AdobeCode>
    <AdobeCode>{18AE23D0-64BB-482A-A37F-6244C2E1247A}</AdobeCode>
    <AdobeCode>{536598C6-4273-4A8A-8DE7-D4F6558909A5}</AdobeCode>
    <AdobeCode>{B6837D28-13EA-4CEC-B195-BA005A9AFD09}</AdobeCode>
    <AdobeCode>{54C9A46B-92DB-4588-B5B0-E7F431721BDD}</AdobeCode>
    <AdobeCode>{15C041E4-E5EC-4735-B725-686D7C2E79CC}</AdobeCode>
    <AdobeCode>{AD0D6BCF-A5E1-4D4A-8FEF-730302381449}</AdobeCode>
    <AdobeCode>{DA654F08-3116-4F4C-96F9-74B5400D94B1}</AdobeCode>
    <AdobeCode>{E65B9805-1491-4646-A348-897966FD8673}</AdobeCode>
    <AdobeCode>{EA92A81A-2EE9-4F66-9A3C-5E9234D582CB}</AdobeCode>
    <AdobeCode>{9AA4F17C-68DD-4AC5-A24A-553B198A0E81}</AdobeCode>
    <AdobeCode>{3E298F95-5609-4B13-98F9-1D2EBE4D3B27}</AdobeCode>
    <AdobeCode>{45C6828E-BD12-46E8-AAE3-DC4EAC36AD8A}</AdobeCode>
    <AdobeCode>{77A0AEDD-04DD-4E0D-92CB-665F15CCE5C0}</AdobeCode>
    <AdobeCode>{F236F367-4724-4FA7-9EBF-3215A008C8AA}</AdobeCode>
    <AdobeCode>{0117C0DC-7FC7-423B-A6CF-B5EB943BCCF1}</AdobeCode>
    <AdobeCode>{7CBFDBAC-F83F-4168-AD39-559450572A21}</AdobeCode>
    <AdobeCode>{965B7CF8-7452-49B1-A757-6A79DB6B35E7}</AdobeCode>
    <AdobeCode>{4792D45D-19C9-4267-9903-5ACA49A6C5DA}</AdobeCode>
    <AdobeCode>{A9C8BEC4-4884-4634-BCD2-36AA115EE8CD}</AdobeCode>
    <AdobeCode>{F19C1D0A-DD08-491C-B1C0-2EDE1FA88C3F}</AdobeCode>
    <AdobeCode>{0ED34AC0-9C6A-4923-922E-214F67F5F172}</AdobeCode>
    <AdobeCode>{2BCEB0DB-426B-4D68-B32F-BF4F03F4EFE6}</AdobeCode>
    <AdobeCode>{6D6F0813-EC0B-4FA7-9222-A38D5E2D16F0}</AdobeCode>
    <AdobeCode>{15ABBE61-D439-43D1-959D-9B37B79E33CE}</AdobeCode>
    <AdobeCode>{E6EF4BD6-F1C3-4DD8-A861-8291B387C173}</AdobeCode>
    <AdobeCode>{4FF20D3F-5045-4BAB-8D05-45C1ACC1CA21}</AdobeCode>
    <AdobeCode>{B565F1D3-B49D-49AF-B116-A4A5617063A6}</AdobeCode>
    <AdobeCode>{C47A9DDE-8A51-4786-BAEF-106DA636E2AA}</AdobeCode>
    <AdobeCode>{1F18B7B7-4DD7-4451-9474-CACF115407A3}</AdobeCode>
    <AdobeCode>{5DCC7DC0-8B35-4699-BAE4-2695BAFA4B8E}</AdobeCode>
    <AdobeCode>{6E7BE028-435A-47B8-98D7-9BB029CB2890}</AdobeCode>
    <AdobeCode>{683A0E75-A6ED-4A15-8E9B-C00500C4FB9D}</AdobeCode>
    <AdobeCode>{6068BFE8-A060-4D34-9CAF-D26E4A05AFE4}</AdobeCode>
    <AdobeCode>{FB43701D-2C3A-4994-92FA-BAE944DE7A68}</AdobeCode>
    <AdobeCode>{B20A7E3D-D00A-4CAD-8191-9C28F5446B79}</AdobeCode>
    <AdobeCode>{1C2438F0-0790-4463-92F0-4463C69DEC91}</AdobeCode>
    <AdobeCode>{78ED15DD-1127-4077-9593-27D0DECE1795}</AdobeCode>
    <AdobeCode>{31ED54CD-498A-40ED-B555-2B6350359295}</AdobeCode>
    <AdobeCode>{B49C2FD3-B1F2-43B9-B000-CA056EA24562}</AdobeCode>
    <AdobeCode>{208D4140-9780-4504-9F1C-2F81819E49D0}</AdobeCode>
    <AdobeCode>{9D4AE88F-02FA-4B28-B5DC-A27A0CD8659B}</AdobeCode>
    <AdobeCode>{70AF74F2-2228-48E3-B242-0CB99F9E7F55}</AdobeCode>
    <AdobeCode>{5E1B8343-A0B3-40BD-8548-838A4C3C50E6}</AdobeCode>
    <AdobeCode>{A3E262B5-0818-4DD2-8831-74D4A5FA5316}</AdobeCode>
    <AdobeCode>{86BB0912-7FA3-4D4B-A533-5A515C05E960}</AdobeCode>
    <AdobeCode>{2C5930A2-BC06-4D47-A899-DCFD8A64E4E8}</AdobeCode>
    <AdobeCode>{7A825C70-821B-47CB-B365-0B8A34629512}</AdobeCode>
    <AdobeCode>{C7E28754-3919-46AA-9FEC-EB49C765F4D5}</AdobeCode>
  </Upgrades><Channel enable="1" id="AdobeMiniBridgeCS5-1">
    <DisplayName>Adobe Mini Bridge CS5</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="3742147" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>3742147</TotalSize>
      <MaxPathComponent>/locale/zh_CN\strings.txt</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>0</TotalSize>
      <MaxPathComponent>/CS5ServiceManager/extensions/Adobe Mini Bridge CS5</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="3742147"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="sq_AL">1</Value>
      <Value lang="ar_AE">1</Value>
      <Value lang="be_BY">1</Value>
      <Value lang="bg_BG">1</Value>
      <Value lang="ca_ES">1</Value>
      <Value lang="zh_CN">1</Value>
      <Value lang="zh_TW">1</Value>
      <Value lang="hr_HR">1</Value>
      <Value lang="cs_CZ">1</Value>
      <Value lang="da_DK">1</Value>
      <Value lang="nl_NL">1</Value>
      <Value lang="en_XC">1</Value>
      <Value lang="en_XM">1</Value>
      <Value lang="en_GB">1</Value>
      <Value lang="en_US">1</Value>
      <Value lang="et_EE">1</Value>
      <Value lang="fi_FI">1</Value>
      <Value lang="fr_FR">1</Value>
      <Value lang="fr_XM">1</Value>
      <Value lang="de_DE">1</Value>
      <Value lang="el_GR">1</Value>
      <Value lang="he_IL">1</Value>
      <Value lang="hu_HU">1</Value>
      <Value lang="hi_IN">1</Value>
      <Value lang="is_IS">1</Value>
      <Value lang="it_IT">1</Value>
      <Value lang="ja_JP">1</Value>
      <Value lang="ko_KR">1</Value>
      <Value lang="lv_LV">1</Value>
      <Value lang="lt_LT">1</Value>
      <Value lang="mk_MK">1</Value>
      <Value lang="nn_NO">1</Value>
      <Value lang="no_NO">1</Value>
      <Value lang="nb_NO">1</Value>
      <Value lang="pl_PL">1</Value>
      <Value lang="pt_BR">1</Value>
      <Value lang="ro_RO">1</Value>
      <Value lang="ru_RU">1</Value>
      <Value lang="sh_YU">1</Value>
      <Value lang="sk_SK">1</Value>
      <Value lang="sl_SI">1</Value>
      <Value lang="es_QM">1</Value>
      <Value lang="es_ES">1</Value>
      <Value lang="sv_SE">1</Value>
      <Value lang="th_TH">1</Value>
      <Value lang="tr_TR">1</Value>
      <Value lang="uk_UA">1</Value>
      <Value lang="vi_VN">1</Value>
      <Value lang="fr_CA">1</Value>
      <Value lang="es_MX">1</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="sq_AL">Adobe Mini Bridge CS5</Value>
      <Value lang="ar_AE">Adobe Mini Bridge CS5</Value>
      <Value lang="be_BY">Adobe Mini Bridge CS5</Value>
      <Value lang="bg_BG">Adobe Mini Bridge CS5</Value>
      <Value lang="ca_ES">Adobe Mini Bridge CS5</Value>
      <Value lang="zh_CN">Adobe Mini Bridge CS5</Value>
      <Value lang="zh_TW">Adobe Mini Bridge CS5</Value>
      <Value lang="hr_HR">Adobe Mini Bridge CS5</Value>
      <Value lang="cs_CZ">Adobe Mini Bridge CS5</Value>
      <Value lang="da_DK">Adobe Mini Bridge CS5</Value>
      <Value lang="nl_NL">Adobe Mini Bridge CS5</Value>
      <Value lang="en_XC">Adobe Mini Bridge CS5</Value>
      <Value lang="en_XM">Adobe Mini Bridge CS5</Value>
      <Value lang="en_GB">Adobe Mini Bridge CS5</Value>
      <Value lang="en_US">Adobe Mini Bridge CS5</Value>
      <Value lang="et_EE">Adobe Mini Bridge CS5</Value>
      <Value lang="fi_FI">Adobe Mini Bridge CS5</Value>
      <Value lang="fr_FR">Adobe Mini Bridge CS5</Value>
      <Value lang="fr_XM">Adobe Mini Bridge CS5</Value>
      <Value lang="de_DE">Adobe Mini Bridge CS5</Value>
      <Value lang="el_GR">Adobe Mini Bridge CS5</Value>
      <Value lang="he_IL">Adobe Mini Bridge CS5</Value>
      <Value lang="hu_HU">Adobe Mini Bridge CS5</Value>
      <Value lang="hi_IN">Adobe Mini Bridge CS5</Value>
      <Value lang="is_IS">Adobe Mini Bridge CS5</Value>
      <Value lang="it_IT">Adobe Mini Bridge CS5</Value>
      <Value lang="ja_JP">Adobe Mini Bridge CS5</Value>
      <Value lang="ko_KR">Adobe Mini Bridge CS5</Value>
      <Value lang="lv_LV">Adobe Mini Bridge CS5</Value>
      <Value lang="lt_LT">Adobe Mini Bridge CS5</Value>
      <Value lang="mk_MK">Adobe Mini Bridge CS5</Value>
      <Value lang="nn_NO">Adobe Mini Bridge CS5</Value>
      <Value lang="no_NO">Adobe Mini Bridge CS5</Value>
      <Value lang="nb_NO">Adobe Mini Bridge CS5</Value>
      <Value lang="pl_PL">Adobe Mini Bridge CS5</Value>
      <Value lang="pt_BR">Adobe Mini Bridge CS5</Value>
      <Value lang="ro_RO">Adobe Mini Bridge CS5</Value>
      <Value lang="ru_RU">Adobe Mini Bridge CS5</Value>
      <Value lang="sh_YU">Adobe Mini Bridge CS5</Value>
      <Value lang="sk_SK">Adobe Mini Bridge CS5</Value>
      <Value lang="sl_SI">Adobe Mini Bridge CS5</Value>
      <Value lang="es_QM">Adobe Mini Bridge CS5</Value>
      <Value lang="es_ES">Adobe Mini Bridge CS5</Value>
      <Value lang="sv_SE">Adobe Mini Bridge CS5</Value>
      <Value lang="th_TH">Adobe Mini Bridge CS5</Value>
      <Value lang="tr_TR">Adobe Mini Bridge CS5</Value>
      <Value lang="uk_UA">Adobe Mini Bridge CS5</Value>
      <Value lang="vi_VN">Adobe Mini Bridge CS5</Value>
      <Value lang="fr_CA">Adobe Mini Bridge CS5</Value>
      <Value lang="es_MX">Adobe Mini Bridge CS5</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "0", "ChannelID", "AdobeMiniBridgeCS5-1")
INSERT INTO PayloadData VALUES("{4438C826-1FD0-4D04-A70B-24FE1580AB21}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeMiniBridgeCS5-1">
    <DisplayName>Adobe Mini Bridge CS5</DisplayName>
  </Channel>')
